#!/usr/bin/perl
# 4190923, 4255013

my $target = $ARGV[2];
my $pkg = $ARGV[0];

############################
# clean up old stuff
my $DATA_FILE = $pkg . "/Contents/Resources/cleanup-list";

open (FILE, $DATA_FILE) || die ;

while (defined ($deleteme = <FILE>)) {
    chomp $deleteme;
    if (length($deleteme) > 0)
    {
        print("cleaning up: $target/$deleteme\n");
        deleteTree($target . $deleteme);
    }
}

exit(0);

####################################################################################

sub deleteTree
{
    my $path            = $_[0];

    if (-e $path)
    {
        if (-d $path
            && !(-l $path))
        {
            local* THEDIR;
            my $file;

            opendir THEDIR, $path;

            while ($file = readdir THEDIR)
            {
                if ($file ne '.' && $file ne '..')
                {
                    deleteTree($path . "/" . $file);
                }
            }

            closedir THEDIR;

            rmdir $path;
        } else {

            unlink $path;
        }
    } else {
        if (-l $path)
        {
            unlink $path;
        }
    }
}

