#!/usr/bin/ruby -d
# 4369653 

# If MySQL is explicitly configured to use /tmp/mysql.sock, create a symlink
#    so it's accessible from new default location /var/mysql/mysql.sock.
#

$dst_root = ARGV[2] ? ARGV[2] : "/"
require 'ftools'

$sock_old = $dst_root + "/tmp/mysql.sock"
$sock_new = $dst_root + "/var/mysql/mysql.sock"
$mysql_dir = $dst_root + "/var/mysql"
$mysql_global_conf = $dst_root + "/etc/my.cnf"
$mysql_server_conf = $mysql_dir + "/my.cnf"
$mysqld = $dst_root + "/usr/libexec/mysqld"
$config_opts_cmd = $dst_root + "/usr/libexec/mysqld --print-defaults"
$make_sym_link = false

# Is Apple-managed mysql db absent?
exit if ! FileTest.directory?($mysql_dir)
# Is a global MySQL config file absent?
exit if ! FileTest.exists?($mysql_global_conf)
# Is a symlink already present?
exit if FileTest.symlink?($sock_new)
# Is a socket already present?
exit if FileTest.socket?($sock_new)
# Is a there something in the way?
exit if FileTest.exists?($sock_new)

# Ask mysqld for its socket config
$config_opts = `#{$config_opts_cmd}`
# Reverse order of options so last will be seen first.
# Is mysqld configured for old socket?
$config_opts.split(/(\s+)/).reverse.each do |option|
	if option == "--socket=/tmp/mysql.sock" || option == "--socket=/private/tmp/mysql.sock"
		File.symlink($sock_old, $sock_new)
		exit
	end
end
