#!/usr/bin/perl

my $TARGET = "$ARGV[2]";
my $SSH_FILE1 = "$TARGET/etc/ssh_config";
my $SSH_FILE2 = "$TARGET/etc/sshd_config";
my $TMP_FILE1 = "$ENV{'INSTALLER_TEMP'}/ssh_config";
my $TMP_FILE2 = "$ENV{'INSTALLER_TEMP'}/sshd_config";

open(AUTHFILE, "< $SSH_FILE1");
while( <AUTHFILE> ) {
	if( m/Tunnel\s+no/ ) {
		$p1Exists = 1;
	}
	if( m/TunnelDevice\s+any:any/ ) {
		$p2Exists = 1;
	}
	if( m/PermitLocalCommand\s+no/ ) {
		$p3Exists = 1;
	}
	if( m/GSSAPIAuthentication/i ) {
        $gs1Exists = 1;
	}
    if( m/GSSAPIDelegateCredentials/i ) {
        $gs2Exists = 1;
    }
    if( m/GSSAPIKeyExchange/i ) {
        $gs3Exists = 1;
    }
    if( m/GSSAPITrustDNS/i ) {
        $gs4Exists = 1;
    }
}
close (AUTHFILE);

open (AUTHFILE, "< $SSH_FILE1");
open(OUTFILE, "> $TMP_FILE1");

$doneBlock = 0;
$doneGS = 0;
while ( <AUTHFILE> ) {
	if (!$doneBlock && m/EscapeChar/i ) {
		print OUTFILE $_;
		if (!$p1Exists) {
			print OUTFILE "#   Tunnel no\n";
		}
		if (!$p2Exists) {
			print OUTFILE "#   TunnelDevice any:any\n";
		}
		if (!$p3Exists) {
			print OUTFILE "#   PermitLocalCommand no\n";
		}
		$doneBlock = 1;
	}
	elsif (!$doneGS && m/GSSAPIAuthentication/i ) {
		print OUTFILE $_;
		if (!$gs2Exists) {
			print OUTFILE "#   GSSAPIDelegateCredentials no\n";
		}
		if (!$gs3Exists) {
			print OUTFILE "#   GSSAPIKeyExchange yes\n";
		}
		if (!$gs4Exists) {
			print OUTFILE "#   GSSAPITrustDNS no\n";
		}
		$doneGS = 1;
	}
	elsif (!$doneGS && m/GSSAPIDelegateCredentials/i ) {
		print OUTFILE $_;
		if (!$gs1Exists) {
			print OUTFILE "#   GSSAPIAuthentication yes\n";
		}
		if (!$gs3Exists) {
			print OUTFILE "#   GSSAPIKeyExchange yes\n";
		}
		if (!$gs4Exists) {
			print OUTFILE "#   GSSAPITrustDNS no\n";
		}
		$doneGS = 1;
	}
	elsif (!$doneGS && m/GSSAPIKeyExchange/i ) {
		print OUTFILE $_;
		if (!$gs1Exists) {
			print OUTFILE "#   GSSAPIAuthentication yes\n";
		}
		if (!$gs2Exists) {
			print OUTFILE "#   GSSAPIDelegateCredentials no\n";
		}
		if (!$gs4Exists) {
			print OUTFILE "#   GSSAPITrustDNS no\n";
		}
		$doneGS = 1;
	}
	elsif (!$doneGS && m/GSSAPITrustDNS/i ) {
		print OUTFILE $_;
		if (!$gs1Exists) {
			print OUTFILE "#   GSSAPIAuthentication yes\n";
		}
		if (!$gs2Exists) {
			print OUTFILE "#   GSSAPIDelegateCredentials no\n";
		}
		if (!$gs3Exists) {
			print OUTFILE "#   GSSAPIKeyExchange yes\n";
		}
		$doneGS = 1;
	}
	elsif (!$doneGS && m/HostbasedAuthentication/i ) {
		print OUTFILE $_;
		if (!$gs1Exists) {
			print OUTFILE "#   GSSAPIAuthentication yes\n";
		}
		if (!$gs2Exists) {
			print OUTFILE "#   GSSAPIDelegateCredentials no\n";
		}
		if (!$gs3Exists) {
			print OUTFILE "#   GSSAPIKeyExchange yes\n";
		}
		if (!$gs4Exists) {
			print OUTFILE "#   GSSAPITrustDNS no\n";
		}
		$doneGS = 1;
	}
	else {
		print OUTFILE $_;
	}
}
if (!$doneGS) {
	if (!$gs1Exists) {
		print OUTFILE "#   GSSAPIAuthentication yes\n";
	}
	if (!$gs2Exists) {
		print OUTFILE "#   GSSAPIDelegateCredentials no\n";
	}
	if (!$gs3Exists) {
		print OUTFILE "#   GSSAPIKeyExchange yes\n";
	}
	if (!$gs4Exists) {
		print OUTFILE "#   GSSAPITrustDNS no\n";
	}
}

close(OUTFILE);
close(AUTHFILE);

open(AUTHFILE, "< $SSH_FILE2");
while( <AUTHFILE> ) {
    if( m/AddressFamily/i ) {
        $p4Exists = 1;
	}
    if( m/\#\s*SyslogFacility\s+AUTH/i ) {
        $p5Change = 1;
	}
    if( m/MaxAuthTries/i ) {
        $p6Exists = 1;
	}
    if( m/\#\s*Compression\s+yes/i ) {
        $p7Change = 1;
	}
    if( m/PermitTunnel/i ) {
        $p8Exists = 1;
	}
    if( m/Example\s+of\s+overriding\s+settings\s+on\s+a\s+per-user\s+basis/i ) {
        $p9Exists = 1;
	}
	if( m/GSSAPIAuthentication/i ) {
        $gs5Exists = 1;
	}
    if( m/GSSAPICleanupCredentials/i ) {
        $gs6Exists = 1;
    }
    if( m/GSSAPIStrictAcceptorCheck/i ) {
        $gs7Exists = 1;
    }
    if( m/GSSAPIKeyExchange/i ) {
        $gs8Exists = 1;
    }
    if( m/GSSAPI\s+options/i ) {
        $gsOptExists = 1;
    }
}
close (AUTHFILE);

open (AUTHFILE, "< $SSH_FILE2");
open(OUTFILE, "> $TMP_FILE2");

$doneGS = 0;
$done4 = 0;
$done5 = 0;
$done6 = 0;
$done7 = 0;
$done8 = 0;
$done9 = 0;
$gsOptExists = 0;
while ( <AUTHFILE> ) {
	if ( !$done4 && (m/Protocol/i)) {
		print OUTFILE $_;
		if (!$p4Exists) {
			print OUTFILE "#AddressFamily any\n";
		}
		$done4 = 1;
	}
	elsif (!$done5 && m/SyslogFacility/i ) {
		if ($p5Change) {
			print OUTFILE "SyslogFacility AUTHPRIV\n";
		}
		else {
			print OUTFILE $_;
		}
		$done5 = 1;
	}
	elsif (!$done6 && m/StrictModes/i ) {
		print OUTFILE $_;
		if (!$p6Exists) {
			print OUTFILE "#MaxAuthTries 6\n";
		}
		$done6 = 1;
	}
	elsif (!$done7 && m/Compression/i ) {
		if ($p7Change) {
			print OUTFILE "#Compression delayed\n";
		}
		else {
			print OUTFILE $_;
		}
		$done7 = 1;
	}
	elsif (!$done8 && m/MaxStartups/i ) {
		print OUTFILE $_;
		if (!$p8Exists) {
			print OUTFILE "#PermitTunnel no\n";
		}
		$done8 = 1;
	}
	elsif ( !$doneGS && (m/GSSAPIAuthentication/i)) {
		if (!$gsOptExists) {
			print "\n";
			print OUTFILE "# GSSAPI options\n";
		}
		print OUTFILE $_;
		if (!$gs6Exists) {
			print OUTFILE "#GSSAPICleanupCredentials yes\n";
		}
		if (!$gs7Exists) {
			print OUTFILE "#GSSAPIStrictAcceptorCheck yes\n";
		}
		if (!$gs8Exists) {
			print OUTFILE "#GSSAPIKeyExchange yes\n";
		}
		$doneGS = 1;
	}
	elsif ( !$doneGS && (m/GSSAPICleanupCredentials/i)) {
		if (!$gsOptExists) {
			print "\n";
			print OUTFILE "# GSSAPI options\n";
		}
		print OUTFILE $_;
		if (!$gs5Exists) {
			print OUTFILE "#GSSAPIAuthentication yes\n";
		}
		if (!$gs7Exists) {
			print OUTFILE "#GSSAPIStrictAcceptorCheck yes\n";
		}
		if (!$gs8Exists) {
			print OUTFILE "#GSSAPIKeyExchange yes\n";
		}
		$doneGS = 1;
	}
	elsif ( !$doneGS && (m/GSSAPIStrictAcceptorCheck/i)) {
		if (!$gsOptExists) {
			print "\n";
			print OUTFILE "# GSSAPI options\n";
		}
		print OUTFILE $_;
		if (!$gs5Exists) {
			print OUTFILE "#GSSAPIAuthentication yes\n";
		}
		if (!$gs6Exists) {
			print OUTFILE "#GSSAPICleanupCredentials yes\n";
		}
		if (!$gs8Exists) {
			print OUTFILE "#GSSAPIKeyExchange yes\n";
		}
		$doneGS = 1;
	}
	elsif ( !$doneGS && (m/GSSAPIKeyExchange/i)) {
		if (!$gsOptExists) {
			print "\n";
			print OUTFILE "# GSSAPI options\n";
		}
		print OUTFILE $_;
		if (!$gs5Exists) {
			print OUTFILE "#GSSAPIAuthentication yes\n";
		}
		if (!$gs6Exists) {
			print OUTFILE "#GSSAPICleanupCredentials yes\n";
		}
		if (!$gs7Exists) {
			print OUTFILE "#GSSAPIStrictAcceptorCheck yes\n";
		}
		$doneGS = 1;
	}
	elsif ( !$doneGS && (m/KerberosGetAFSToken/i)) {
		print OUTFILE $_;
		if ((!$gs5Exists || !$gs6Exists || !$gs7Exists || !$gs8Exists) && !$gsOptExists) {
			print OUTFILE "\n";
			print OUTFILE "# GSSAPI options\n";
		}
		if (!$gs5Exists) {
			print OUTFILE "#GSSAPIAuthentication yes\n";
		}
		if (!$gs6Exists) {
			print OUTFILE "#GSSAPICleanupCredentials yes\n";
		}
		if (!$gs7Exists) {
			print OUTFILE "#GSSAPIStrictAcceptorCheck yes\n";
		}
		if (!$gs8Exists) {
			print OUTFILE "#GSSAPIKeyExchange yes\n";
		}
		$doneGS = 1;
	}
	else {
		print OUTFILE $_;
	}
}
if (!$doneGS) {
	if (!$gsOptExists) {
		print OUTFILE "# GSSAPI options\n";
	}
	if (!$gs5Exists) {
		print OUTFILE "#GSSAPIAuthentication yes\n";
	}
	if (!$gs6Exists) {
		print OUTFILE "#GSSAPICleanupCredentials yes\n";
	}
	if (!$gs7Exists) {
		print OUTFILE "#GSSAPIStrictAcceptorCheck yes\n";
	}
	if (!$gs8Exists) {
		print OUTFILE "#GSSAPIKeyExchange yes\n";
	}

}
if (!$p9Exists) {
	print OUTFILE "\n";
	print OUTFILE "# Example of overriding settings on a per-user basis\n";
	print OUTFILE "#Match User anoncvs\n";
	print OUTFILE "#	X11Forwarding no\n";
	print OUTFILE "#	AllowTcpForwarding no\n";
	print OUTFILE "#	ForceCommand cvs server\n";
}

close(OUTFILE);
close(AUTHFILE);

system("cp -f \"$TMP_FILE1\" \"$SSH_FILE1\"");
system("cp -f \"$TMP_FILE2\" \"$SSH_FILE2\"");

exit(0);
