#!/usr/bin/perl
# 4526825

########################################################
my $PLIST_LOC           = $ARGV[2] . "/etc/authorization";
my $PLISTBUDDY_LOC      = $ARGV[0] . "/Contents/Resources/PlistBuddy";
my $comAppleExists = 0;
my $comAppleDBAdvisoryExists = 0;
########################################################

if ((! -f $PLISTBUDDY_LOC) || (! -f $PLIST_LOC)) {
	print "addDBToAuth failed.  PlistBuddy or /etc/authorization not found.";
	exit(0);
}

open(AUTHFILE, "$PLIST_LOC");
while( <AUTHFILE> ) {
    # Check for com.apple.
	if( m/\<key\>com\.apple\.\<\/key\>/i ) {
        $comAppleExists = 1;
    }
	# Check for com.apple.dashboard.advisory.allow
    if( m/\<key\>com\.apple\.dashboard\.advisory\.allow\<\/key\>/i ) {
        $comAppleDBAdvisoryExists = 1;
    }
}
close(AUTHFILE);

########################################################

if( !($comAppleExists) ) {
    # Add dictionary
	system( $PLISTBUDDY_LOC,
        "-c", "add :rights:com.apple. dict",
        "-c", "add :rights:com.apple.:rule string \"default\"",
        $PLIST_LOC
    );
}

########################################################

if( $comAppleDBAdvisoryExists ) {
    # Remove existing dictionary
	system( $PLISTBUDDY_LOC,
        "-c", "delete :rights:com.apple.dashboard.advisory.allow",
        $PLIST_LOC
    );
	$comAppleDBAdvisoryExists = 0;
}

if( !($comAppleDBAdvisoryExists) ) {
    # Add dictionary
	system( $PLISTBUDDY_LOC,
        "-c", "add :rights:com.apple.dashboard.advisory.allow dict",
        "-c", "add :rights:com.apple.dashboard.advisory.allow:class string \"user\"",
        "-c", "add :rights:com.apple.dashboard.advisory.allow:group string \"admin\"",
        "-c", "add :rights:com.apple.dashboard.advisory.allow:shared bool false",
        "-c", "add :rights:com.apple.dashboard.advisory.allow:timeout integer 300",
        $PLIST_LOC
    );
}

exit(0);
