#!/usr/bin/perl

use strict;

our $RESOURCES	= $ARGV[0]."/Contents/Resources";
our $TARGET		= $ARGV[2];
our $HOME		= $ENV{'HOME'};
our $USER		= $ENV{'USER'};
our $APP		= "/Applications/Utilities/iMac G5 Sleep Light Updater.app";


#Only do this if we are installing to the boot volume
if ($TARGET eq "/")
{
	#And we're authenticated as root
	if ($< == 0)
	{
		#Go through each item in the startup app array, and find if $APP is in the list already
		my $found = 0;
		my $i = 0;
		while (! $found)
		{
			my $invocation	=	qq{"$RESOURCES/PlistBuddy" } .
								qq{"-c" "print AutoLaunchedApplicationDictionary:$i:Path" } .
								qq{"$HOME/Library/Preferences/loginwindow.plist"};
		
			my $path = `$invocation`;
			my $errorCode = $? >> 8;

			if ($errorCode != 0)
			{
				last;
			}

			chomp $path;
			
			# PlistBuddy returns "Does Not Exist" when we hit the end of the array
			if ($path =~ "Does Not Exist")
			{
				last;
			}
			
			if ($path eq $APP)
			{
				$found = 1;
			}
						
			$i ++;
		}
		
		# If $APP is not already there, add it!
		if (!$found)
		{
			my $invocation = qq{"$RESOURCES/PlistBuddy" } .
				qq{"-c" "add AutoLaunchedApplicationDictionary array" } .
				qq{"-c" "add AutoLaunchedApplicationDictionary:0 dict" } .
				qq{"-c" "cd AutoLaunchedApplicationDictionary:0" } .
				qq{"-c" "add Path string '$APP'" } .
				qq{"-c" "add Hide bool false" } .
				qq{"-c" "add InstallerAdded bool true" } .
				qq{"$HOME/Library/Preferences/loginwindow.plist" };
				
			my $path = `/usr/bin/mktemp -d /private/tmp/install.XXXXXXXX`;
			chomp($path);
			my $ALWIscript = ($path . "/ALWI");

			sysopen(SCRIPT, $ALWIscript, 0x0001 | 0x0200 | 0x0800) or exit 0;
			print SCRIPT "#!/bin/sh\n\n";
			print SCRIPT "$invocation\n\n";
			close SCRIPT;
			
			`/bin/chmod +rx "$path"`;
			`/bin/chmod +rx "$ALWIscript"`;
			`/usr/bin/su -m "$USER" -c "$ALWIscript"`;
			system("/bin/rm", "-rf", "$path");
		}
	}
}

# now make sure to exit 0
exit 0;
