#!/usr/bin/perl

use Foundation;

####################################################################################
my $MYAPP				= "/Applications/Utilities/MacBook SMC Firmware Update.app";
my $SUAPP				= "Software Update\.app";
my $SUAPP_IS_RUNNING	= 0;
####################################################################################

open(PSOUT, "/bin/ps -awwx |");
while( <PSOUT> ) {
	if( /$SUAPP/ ) {
		$SUAPP_IS_RUNNING = 1;
	}
}
close(PSOUT);

# Lurk if SU is not running
if (!$SUAPP_IS_RUNNING) 
{
	unless($ENV{'COMMAND_LINE_INSTALL'}) {
		lurkAndLaunch( 'app' => "Installer", 'launchExpr' => "open '$ARGV[2]/$MYAPP'");
	}
}
# Lurk if SU is running, environment variable exists, and no restart is pending
elsif (($ENV{'SURestartAction'}) && ($ENV{'SURestartAction'} eq "IFNoRestart"))
{
	unless($ENV{'COMMAND_LINE_INSTALL'}) {
		lurkAndLaunch( 'app' => "Software Update", 'launchExpr' => "open '$ARGV[2]/$MYAPP'");
	}
}
# Otherwise, add to login items
else
{
	our $TARGET		= $ARGV[2];
	our $HOME		= $ENV{'HOME'};
	our $USER		= $ENV{'USER'};

	#Only do this if we are installing to the boot volume and authenticated as root
	if (($TARGET eq "/") && ($< == 0))
	{
		my $script = "tell application \\\"System Events\\\"\\n make new login item at end of login items with properties {path:\\\"$MYAPP\\\"}\\n end tell";
		
		my $perlScript = "#!/usr/bin/perl\n";
		$perlScript .= "use Foundation;\n";
		$perlScript .= "my \$scriptString = NSString->stringWithCString_encoding_(\"$script\", 1);\n";
		$perlScript .= "my \$appleScript = NSAppleScript->alloc();\n";
		$perlScript .= "\$appleScript->initWithSource_(\$scriptString);\n";
		$perlScript .= "my \$aeDesc = \$appleScript->executeAndReturnError_(\"NULL\");\n";
		$perlScript .= "exit(0);\n";
		
		my $path = `/usr/bin/mktemp -d /private/tmp/install.XXXXXXXX`;
		chomp($path);
		my $ALWIscript = ($path . "/ALWI");
		
		sysopen(SCRIPT, $ALWIscript, 0x0001 | 0x0200 | 0x0800) or exit 0;
		print SCRIPT "$perlScript\n\n";
		close SCRIPT;
		
		`/bin/chmod +rx "$path"`;
		`/bin/chmod +rx "$ALWIscript"`;
		`/usr/bin/su -m "$USER" -c "$ALWIscript"`;
		system("/bin/rm", "-rf", "$path");
	}
}

exit 0;

sub lurkAndLaunch {
	use Fcntl;
	my %args = @_;
	my $result = 0;

	# make sure we have 	
	if($args{'launchExpr'} && $args{'app'}) {
		# Make sure the installer is running at this point
		`/usr/bin/killall -s -m $args{'app'} >/dev/null 2>&1`;
		if($? == 0) {
			my $path = `/usr/bin/mktemp -d /private/tmp/install.XXXXXXXX`;
			chomp($path);
			my $lurkScript = ($path . "/lurker");

			if($? == 0) {

				if(sysopen(LURKER, $lurkScript, O_WRONLY | O_EXCL | O_CREAT)) {

					my $scriptData = (
                                                "#!/usr/bin/perl\n" .
                                                "while(0 == system(\"/usr/bin/killall -s -m $args{'app'} >/dev/null 2>&1\")) {\n" .
                                                " sleep(2);\n" .
                                                "} \n" .
    											"delete \$ENV{'TMPDIR'};\n" .
                                                "system(\"$args{'launchExpr'}\");\n" .
                                                "unlink(\"\$0\");\n"
						);

					print(LURKER $scriptData);

					close(LURKER);

					chmod(oct(500), $lurkScript);

					if(0 == system("$lurkScript >/dev/null 2>&1 &")) {

						$result = 1;;
					}

				} else {

					print(STDERR "error opening temporary file!");
				}
			}
		}
	} 

	return($result);
}

