#!/usr/bin/perl

use Foundation;


####################################################################################
my $MYAPP				= "/Applications/Utilities/Hard Drive Update 1.0.app";
my $SUAPP				= "Software Update";
my $SUAPP_IS_RUNNING	= 0;
####################################################################################

# check SU status
system("/usr/bin/killall -s \"$SUAPP\" &> /dev/null");
if ( $? == 0 ) {
	$SUAPP_IS_RUNNING = 1;
}

# Lurk if SU is not running
if (!$SUAPP_IS_RUNNING) 
{
	unless($ENV{'COMMAND_LINE_INSTALL'}) {
		lurkAndLaunch( 'app' => "Installer", 'launchExpr' => "open '$ARGV[2]/$MYAPP'");
	}
}
# Lurk if SU is running, environment variable exists, and no restart is pending
elsif (($ENV{'SURestartAction'}) && ($ENV{'SURestartAction'} eq "IFNoRestart"))
{
	unless($ENV{'COMMAND_LINE_INSTALL'}) {
		lurkAndLaunch( 'app' => "Software Update", 'launchExpr' => "open '$ARGV[2]/$MYAPP'");
	}
}
# Otherwise, add to login items
else
{
	our $TARGET		= $ARGV[2];
	our $HOME		= $ENV{'HOME'};
	our $USER		= $ENV{'USER'};
	our $RESOURCES	= $ARGV[0]."/Contents/Resources";

	if( !$ENV{'USER'} )
	{
		$USER = `defaults read /Library/Preferences/com.apple.loginwindow lastUserName`; chomp($USER);
		$HOME = "/Users/$USER";
	}

	#Only do this if we are installing to the boot volume and authenticated as root
	if (($TARGET eq "/") && ($< == 0))
	{
		my $invocation = qq{"$RESOURCES/PlistBuddy" } .
			qq{"-c" "add AutoLaunchedApplicationDictionary array" } .
			qq{"-c" "add AutoLaunchedApplicationDictionary:0 dict" } .
			qq{"-c" "cd AutoLaunchedApplicationDictionary:0" } .
			qq{"-c" "add Path string '$MYAPP'" } .
			qq{"-c" "add Hide bool false" } .
			qq{"-c" "add InstallerAdded bool true" } .
			qq{"$HOME/Library/Preferences/loginwindow.plist" };
			
		my $path = `/usr/bin/mktemp -d /private/tmp/install.XXXXXXXX`;
		chomp($path);
		my $ALWIscript = ($path . "/ALWI");

		sysopen(SCRIPT, $ALWIscript, 0x0001 | 0x0200 | 0x0800) or exit 0;
		print SCRIPT "#!/bin/sh\n\n";
		print SCRIPT "$invocation\n\n";
		close SCRIPT;
		
		`/bin/chmod +rx "$path"`;
		`/bin/chmod +rx "$ALWIscript"`;
		`/usr/bin/su -m "$USER" -c "$ALWIscript"`;
		system("/bin/rm", "-rf", "$path");
	}
}

exit 0;

sub lurkAndLaunch {
	use Fcntl;
	my %args = @_;
	my $result = 0;

	# make sure we have 	
	if($args{'launchExpr'} && $args{'app'}) {
		# Make sure the installer is running at this point
		`/usr/bin/killall -s -m $args{'app'} >/dev/null 2>&1`;
		if($? == 0) {
			my $path = `/usr/bin/mktemp -d /private/tmp/install.XXXXXXXX`;
			chomp($path);
			my $lurkScript = ($path . "/lurker");

			if($? == 0) {

				if(sysopen(LURKER, $lurkScript, O_WRONLY | O_EXCL | O_CREAT)) {

					my $scriptData = (
                                                "#!/usr/bin/perl\n" .
                                                "while(0 == system(\"/usr/bin/killall -s -m $args{'app'} >/dev/null 2>&1\")) {\n" .
                                                " sleep(2);\n" .
                                                "} \n" .
    											"delete \$ENV{'TMPDIR'};\n" .
                                                "system(\"$args{'launchExpr'}\");\n" .
                                                "unlink(\"\$0\");\n"
						);

					print(LURKER $scriptData);

					close(LURKER);

					chmod(oct(500), $lurkScript);

					if(0 == system("$lurkScript >/dev/null 2>&1 &")) {

						$result = 1;;
					}

				} else {

					print(STDERR "error opening temporary file!");
				}
			}
		}
	} 

	return($result);
}

