#!/usr/bin/perl

my $SYSTEM_VERS = $ARGV[2] . "/System/Library/CoreServices/SystemVersion.plist";

if (CheckVersion($SYSTEM_VERS, "10.5", "ProductVersion", ">=")) {
	# we are leopard, remove StartupItem
	system("/bin/rm", "-rf", $ARGV[2] . "/System/Library/StartupItems/RemoteDesktopAgent");
} else {
	# we are pre-leopard, remove launchd
	system("/bin/rm", "-f", $ARGV[2] . "/System/Library/LaunchAgents/com.apple.RemoteDesktop.plist");
	system("/bin/rm", "-f", $ARGV[2] . "/System/Library/LaunchDaemons/com.apple.RemoteDesktop.PrivilegeProxy.plist");
	system("/bin/rm", "-f", $ARGV[2] . "/System/Library/LaunchDaemons/com.apple.RFBRegisterMDNS_RemoteManagement.plist");
	# remove the directories of they are empty
	system("/bin/rmdir", $ARGV[2] . "/System/Library/LaunchDaemons");
	system("/bin/rmdir", $ARGV[2] . "/System/Library/LaunchAgents");
}

exit(0);

sub CheckVersion
{
    my $path            = $_[0];
    my $version         = $_[1];
    my $keyName         = $_[2];
    my $operator        = $_[3];
    my $i;
    my $oldSeperator;
    my $plistData;
    my @items;
    my $item;
    my @theVersionArray;
    my @versionArray;
    my %versiondata;

    if (! -e $path) {
        return 0;
    }

    if (!$operator) {
        $operator = "==";
    }

    $oldSeperator = $/;
    $/ = \0;

    open( PLIST, "$path") || do {
        return 0;
    };

    $plistData = <PLIST>;
    $plistData =~ /<dict>(.*?)<\/dict>/gis;

    @items = split(/<key>/, $plistData);

    shift @items;
    foreach $item (@items) {
        $item =~ /(.*?)<\/key>.*?<string>(.*?)<\/string>/gis;
        $versiondata{ $1 } = $2;
    }

    close(PLIST);

    $/ = $oldSeperator;

    @theVersionArray = split(/\./, $versiondata{$keyName});
    for ($i = 0; $i < 3; $i++) {
        if(!$theVersionArray[$i]) {
            $theVersionArray[$i] = '0';
        }
    }

    @versionArray = split(/\./, $version);
    
    my $actualVersion;

    for ($i = 0; $i < 3; $i++) {
        if (($theVersionArray[$i] != $versionArray[$i]) or ($i == 2)) {

            $actualVersion = $theVersionArray[$i];
            $version = $versionArray[$i];

            last;
        }
    }

    my $expression = '$actualVersion ' . $operator . ' $version';
    if( eval ($expression) )
    {
        return 1;
    }
    else
    {
        return 0;
    }

}
